//+------------------------------------------------------------------+
//|                                                     Range_v2.mq4 |
//|                                  Copyright  2006, Forex-TSD.com |
//|                         Written by IgorAD,igorad2003@yahoo.co.uk |   
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |                                      
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Forex-TSD.com "
#property link      "http://www.forex-tsd.com/"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Red
#property indicator_width1 3
#property indicator_color2 White
#property indicator_width2 3
#property indicator_maximum 1.05
#property indicator_minimum -0.05

extern int TimeFrame=1440;

double ExtMapBuffer1[];
double ExtMapBuffer2[];

int init()
{
   string short_name;
   
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0, ExtMapBuffer1);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(1,ExtMapBuffer2);
      
   
   short_name="HeikenAshiSW("+TimeFrame+")";
   IndicatorShortName(short_name);
   
   
   switch(TimeFrame) 
   {
   case 1    : TimeFrame=PERIOD_M1;  break; 
   case 5    : TimeFrame=PERIOD_M5;  break;
   case 15   : TimeFrame=PERIOD_M15; break;
   case 30   : TimeFrame=PERIOD_M30; break;
   case 60   : TimeFrame=PERIOD_H1;  break;
   case 240  : TimeFrame=PERIOD_H4;  break;
   case 1440 : TimeFrame=PERIOD_D1;  break;
   case 7200 : TimeFrame=PERIOD_W1;  break;
   case 28800: TimeFrame=PERIOD_MN1; break;
   default  : TimeFrame=Period();   break;
   }
return(0);
}

int start()
{
   datetime TimeArray[];
   int i=0,y=0, prevy=0;  
   int counted_bars=IndicatorCounted();
   
   
      if (TimeFrame<Period()) 
      {
      SetIndexDrawBegin(0,Bars);  
      SetIndexDrawBegin(1,Bars);
      Comment("Incorrect TimeFrame");
      return(0);
      }

   if ( counted_bars > 0 )  int limit=Bars-counted_bars;
   if ( counted_bars < 0 )  return(0);
   if ( counted_bars ==0 )  limit=Bars-1;  
     
   
   
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame);
         
   for(i=0,y=0;i<limit;i++)
   {
   if (Time[i]<TimeArray[y]) y++;
   ExtMapBuffer1[i]=iCustom(NULL,TimeFrame,"Heiken Ashi_SW",0,y) ;
   ExtMapBuffer2[i]=iCustom(NULL,TimeFrame,"Heiken Ashi_SW",1,y) ; 
   } 
   return(0);
}